/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HscExclusiveLock;
import com.ibm.hsc.common.util.ReqItem;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;

public class HscRwLock {
    private Hashtable ht = new Hashtable();
    private LinkedList rt = new LinkedList();
    private int running_type = 0;
    private int waiting_num = 0;
    private int ready_num = 0;
    private int running_num = 0;
    private int ready_type = 0;
    private int total_read = 0;
    private int total_write = 0;
    private String m_id = new String();
    static final int ST_WAITING = 0;
    static final int ST_READY = 1;
    static final int ST_RUNNING = 2;
    static final int LT_READ = 0;
    static final int LT_WRITE = 1;
    static final int LT_EWRITE = 2;
    static final int LT_GREAD = 3;
    static final int LT_GWRITE = 4;
    static final int RS_GOTLOCK = 1;
    static final int RS_INQUEUE = 2;
    static final int RS_INVALID = 3;
    static final String RWLOCK_INVALID_LOCK_TYPE = "RWLOCK-01: Invalid lock type";
    static final String RWLOCK_ACQUIRE_LOCK_TIMEOUT = "RWLOCK-02: Failed to acquire lock because of timeout";
    static final String RWLOCK_ILLEGAL_NESTED_LOCK_TYPE = "RWLOCK-03: Illegal nested lock type requested";
    static final String RWLOCK_LOCK_NOT_HELD = "RWLOCK-04: Lock not held";

    public HscRwLock(String string) {
        this.m_id = string;
    }

    public String getMid() {
        return this.m_id;
    }

    public synchronized void print() {
        System.out.println();
        System.out.println("==================================================================");
        System.out.println("running  running   ready   ready   waiting   total_run   total_run");
        System.out.println("type     number    type    number  number    read        write");
        String string = this.running_type == 0 ? "R        " : (this.running_type == 1 ? "W        " : (this.running_type == 2 ? "EW       " : (this.running_type == 3 ? "GR       " : "GW       ")));
        string = string + this.running_num;
        string = this.ready_type == 0 ? string + "         R        " : (this.ready_type == 1 ? string + "         W        " : (this.ready_type == 2 ? string + "         EW       " : (this.ready_type == 3 ? string + "         GR       " : string + "         GW       ")));
        string = string + this.ready_num + "       " + this.waiting_num;
        string = string + "        " + this.total_read + "          " + this.total_write;
        System.out.println(string);
        System.out.println();
        System.out.println("Count  LockType  Status  Thread");
        ListIterator listIterator = this.rt.listIterator(0);
        while (listIterator.hasNext()) {
            ReqItem reqItem = (ReqItem)listIterator.next();
            string = reqItem.GetCount() + "      ";
            int n = reqItem.GetLockType();
            string = n == 0 ? string + "R         " : (n == 1 ? string + "W         " : (n == 2 ? string + "EW        " : (n == 3 ? string + "GR        " : string + "GW        ")));
            string = string + reqItem.GetStatus() + "       " + reqItem.GetThread();
            System.out.println(string);
        }
        System.out.println();
    }

    public synchronized int lock(int n) {
        return this.lock(n, 0L);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int lock(int var1_1, long var2_2) {
        if (var1_1 < 0 && var1_1 > 4) {
            throw new IllegalArgumentException("RWLOCK-01: Invalid lock type " + var1_1);
        }
        var4_3 = (ReqItem)this.ht.get(Thread.currentThread());
        if (var4_3 != null) {
            if (var4_3.GetLockType() == 0 && (var1_1 == 1 || var1_1 == 2)) {
                throw new IllegalArgumentException("RWLOCK-03: Illegal nested lock type requested");
            }
            var4_3.IncreaseCount();
            System.out.println("HscRwLock: Existing Lock " + var1_1 + " on " + this.m_id);
            return 1;
        }
        var4_3 = new ReqItem(Thread.currentThread(), var1_1);
        if (this.waiting_num == 0 && (var1_1 == 0 && (this.running_type == 0 || this.running_num == 0) && (this.ready_type == 0 || this.ready_num == 0) || this.ready_num == 0 && this.running_num == 0)) {
            if (var1_1 == 2) {
                HscExclusiveLock.GetHscExclusiveLock().LockExclusiveWrite();
            }
            var4_3.SetStatus(2);
            this.rt.add(var4_3);
            this.ht.put(Thread.currentThread(), var4_3);
            ++this.running_num;
            this.running_type = var1_1;
            System.out.println("HscRwLock: Got Lock " + var1_1 + " on " + this.m_id);
            return 1;
        }
        var4_3.SetStatus(0);
        this.rt.add(var4_3);
        this.ht.put(Thread.currentThread(), var4_3);
        ++this.waiting_num;
        if (var1_1 == 3 || var1_1 == 4) {
            return 2;
        }
        block2: while (true) {
            block14: {
                try {
                    if (var2_2 <= 0L) {
                        this.wait(30000L);
                        break block14;
                    }
                    this.wait(var2_2);
                    var5_4 = this.rt.listIterator(0);
                    while (var5_4.hasNext()) {
                        var4_3 = (ReqItem)var5_4.next();
                        if (!var4_3.GetThread().equals(Thread.currentThread())) continue;
                        --this.waiting_num;
                        var5_4.remove();
                        this.ht.remove(Thread.currentThread());
                    }
                    throw new IllegalArgumentException("RWLOCK-02: Failed to acquire lock because of timeout");
                }
                catch (InterruptedException var5_5) {
                    // empty catch block
                }
            }
            var5_4 = this.rt.listIterator(0);
            do {
                if (!var5_4.hasNext()) continue block2;
                var4_3 = (ReqItem)var5_4.next();
                if (var4_3.GetStatus() == 0) ** break;
            } while (!var4_3.GetThread().equals(Thread.currentThread()));
            break;
        }
        if (var4_3.GetStatus() == 1) {
            if (var1_1 == 2) {
                HscExclusiveLock.GetHscExclusiveLock().LockExclusiveWrite();
            }
            var4_3.SetStatus(2);
            --this.ready_num;
            ++this.running_num;
            this.running_type = var1_1;
            System.out.println("HscRwLock: Got Lock " + var1_1 + " on " + this.m_id);
            return 1;
        }
        System.out.println("HscRwLock: Invalid Lock Status");
        return 3;
    }

    public synchronized void unlock() {
        ReqItem reqItem = (ReqItem)this.ht.get(Thread.currentThread());
        if (reqItem == null) {
            System.out.println("HscRwLock: Lock not held");
            throw new IllegalArgumentException(RWLOCK_LOCK_NOT_HELD);
        }
        ListIterator listIterator = this.rt.listIterator(0);
        while (listIterator.hasNext()) {
            reqItem = (ReqItem)listIterator.next();
            if (reqItem.GetStatus() != 2 || !reqItem.GetThread().equals(Thread.currentThread())) continue;
            reqItem.DecreaseCount();
            if (reqItem.GetCount() != 0) continue;
            if (reqItem.GetLockType() == 0 || reqItem.GetLockType() == 3) {
                ++this.total_read;
            } else {
                ++this.total_write;
            }
            --this.running_num;
            listIterator.remove();
            this.ht.remove(Thread.currentThread());
            if (reqItem.GetLockType() == 2) {
                HscExclusiveLock.GetHscExclusiveLock().UnlockExclusiveWrite();
            }
            System.out.println("HscRwLock: Released Lock on " + this.m_id);
            if (this.running_num == 0) break;
            return;
        }
        while (listIterator.hasNext()) {
            reqItem = (ReqItem)listIterator.next();
            if (reqItem.GetStatus() != 0) continue;
            if (reqItem.GetLockType() == 0) {
                reqItem.SetStatus(1);
                --this.waiting_num;
                ++this.ready_num;
                this.ready_type = 0;
                reqItem.GetThread().interrupt();
                continue;
            }
            if (this.ready_num == 0) {
                Thread thread = reqItem.GetThread();
                int n = reqItem.GetLockType();
                reqItem.SetStatus(1);
                --this.waiting_num;
                ++this.ready_num;
                this.ready_type = n;
                if (n == 4 || n == 4) {
                    if (!thread.isAlive() || !thread.isInterrupted()) continue;
                    thread.interrupt();
                } else {
                    reqItem.GetThread().interrupt();
                }
            }
            return;
        }
    }

    public boolean isWriteLock() {
        ReqItem reqItem = (ReqItem)this.ht.get(Thread.currentThread());
        if (reqItem == null) {
            return false;
        }
        return reqItem.GetLockType() == 1;
    }

    public synchronized int getLockState(int n) {
        ReqItem reqItem = (ReqItem)this.ht.get(Thread.currentThread());
        if (reqItem == null) {
            System.out.println("HscRwLock G: Lock not held");
            throw new IllegalArgumentException(RWLOCK_LOCK_NOT_HELD);
        }
        if (n != 3 && n != 4) {
            throw new IllegalArgumentException(RWLOCK_INVALID_LOCK_TYPE);
        }
        reqItem = (ReqItem)this.rt.getFirst();
        if (reqItem.GetThread().equals(Thread.currentThread()) && reqItem.GetLockType() == n && reqItem.GetStatus() == 1) {
            reqItem.SetStatus(2);
            --this.ready_num;
            ++this.running_num;
            this.running_type = n;
            System.out.println("HscRwLock: Got Lock " + n + " on " + this.m_id);
            return 1;
        }
        return 2;
    }
}

